<?php

namespace App\Http\Controllers\Trade;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Trade\NocForMandap\CreateRequest;
use App\Http\Requests\Trade\NocForMandap\UpdateRequest;
use App\Services\Trade\NocForMandapService;
use App\Models\Trade\TradeNocForMandap;
use App\Services\CommonService;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\Status;
use App\Models\ApprovalHierarchies;
use App\Models\ServiceName;

class NOCForMandapController extends Controller
{
    protected $nocForMandapService;
    protected $commonService;

    public function __construct(NocForMandapService $nocForMandapService, CommonService $commonService)
    {
        $this->nocForMandapService = $nocForMandapService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('trade.noc-mandap.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {
        // dd($request->all());
        $nocForMandapService = $this->nocForMandapService->store($request);

        if ($nocForMandapService[0]) {
            return response()->json([
                'success' => 'Application Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $nocForMandapService[1]
            ]);
        }
    }

    public function edit(string $id)
    {
        //$data = TradeNocForMandap::findOrFail(decrypt($id));
         $id = decrypt($id);
        $data = TradeNocForMandap::findOrFail($id);
        //dd($data);
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

         $status = Status::where('table_id', $id)
        ->where('service_id', $data->service_id)
        ->first();
        $servicename = ServiceName::pluck('reject_certificate', 'service_id')->toArray();

        return view('trade.noc-mandap.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
            'servicename' => $servicename
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $nocForMandapService = $this->nocForMandapService->update($request, $id);

        if ($nocForMandapService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $nocForMandapService[1]
            ]);
        }
    }

    // public function show_old($id)
    // {
    //     $data = TradeNocForMandap::with('user')->findOrFail(decrypt($id));
    //     $dataone = ApprovalHierarchies::where('service_id',$data->service_id)->where('table_id',$data->id)->first();


    //     $pdf = SnappyPdf::loadView('trade.noc-mandap.nocmandapcertificate', ['data' => $data, 'dataone'=>$dataone]);
    //     $pdf->setPaper('a4')
    //         ->setOption('margin-top', 10)
    //         ->setOption('margin-bottom', 10)
    //         ->setOption('margin-left', 5)
    //         ->setOption('margin-right', 5)
    //         ->setOption('enable-smart-shrinking', true)
    //         ->setOption('disable-smart-shrinking', false)
    //         ->setOption('no-stop-slow-scripts', true)
    //          // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
    //         ->setOption('footer-left', 'Page: [page] of [toPage]');
    //     return $pdf->inline('certificate.pdf');
    // }

    public function show($id, Request $request)
    {
        //$dataone = TradeNocForMandap::with('user')->findOrFail(decrypt($id));
        $id = decrypt($id);
        $data = TradeNocForMandap::with('user')->findOrFail($id);
        $dataone = ApprovalHierarchies::where('service_id', $data->service_id)
            ->where('table_id', $data->id)
            ->first();

        $pdf = SnappyPdf::loadView('trade.noc-mandap.nocmandapcertificate', [
            'data' => $data,
            'dataone' => $dataone
        ]);


        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        if ($request->query('download') === 'pdf') {
            return $pdf->download('certificate.pdf');
        }

        return $pdf->inline('certificate.pdf');
    }

    public function downloadRejectionCertificate($statusId, Request $request)
{
       $id = decrypt($statusId);
        $data = TradeNocForMandap::findOrFail($id);
        $dataone = ApprovalHierarchies::where('service_id', $data->service_id)
            ->where('table_id', $data->id)
            ->first();

    $pdf = SnappyPdf::loadView('trade.noc-mandap.rejectioncertificatenote', [
            'data' => $data,
            'dataone' => $dataone
        ])
        ->setPaper('a4')
        ->setOption('margin-top', 10)
        ->setOption('margin-bottom', 10)
        ->setOption('margin-left', 5)
        ->setOption('margin-right', 5)
        ->setOption('enable-smart-shrinking', true)
        ->setOption('disable-smart-shrinking', false)
        ->setOption('no-stop-slow-scripts', true)
         // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
        ->setOption('footer-left', 'Page: [page] of [toPage]');

    if ($request->query('download') === 'pdf') {
        return $pdf->download('Rejection_Note_' . $statusId . '.pdf');
    }

    return $pdf->inline('Rejection_Note_' . $statusId . '.pdf');
}

}
