<?php

namespace App\Http\Controllers\Trade;

use App\Models\Status;
use App\Models\SbiPayment;
use App\Models\WaterPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\Trade\PlumberLicenseService;
use App\Models\WaterDepartment\WaterPlumberLicense;
use App\Http\Requests\WaterDepartment\PlumberLicense\CreateRequest;
use App\Http\Requests\WaterDepartment\PlumberLicense\UpdateRequest;


class PlumberLicenseController extends Controller
{
    protected $plumberLicenseService;
    protected $commonService;

    public function __construct(PlumberLicenseService $plumberLicenseService, CommonService $commonService)
    {
        $this->plumberLicenseService = $plumberLicenseService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $user = Auth::user();

        return view('trade.plumber-license.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $plumberLicenseService = $this->plumberLicenseService->store($request);

        if ($plumberLicenseService[0]) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $plumberLicenseService[1]
            ]);
        }
    }

    public function edit(string $id)
    {
        $data = WaterPlumberLicense::findOrFail(decrypt($id));

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $status = Status::where('table_id', decrypt($id))
        ->where('service_id', $data->service_id)
        ->first();

        return view('trade.plumber-license.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $plumberLicenseService = $this->plumberLicenseService->update($request, $id);

        if ($plumberLicenseService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $plumberLicenseService[1]
            ]);
        }
    }

    public function show($id)
    {
        $data = WaterPlumberLicense::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('trade.plumber-license.plumbercertificate', ['data' => $data,'paymentdata'=>$paymentdata]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = WaterPlumberLicense::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $rate = WaterPayment::where('service_id', $data->service_id)->where('type', $data->Water_Connection_Usage)->value('rate');

        $pdf = SnappyPdf::loadView('trade.plumber-license.receipt', ['data' => $data,
           'paymentdata' => $paymentdata, 'rate' => $rate]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
