<?php

namespace App\Http\Controllers\Trade;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\Trade\RenewMarriageLicense;
use App\Services\Trade\RenewLicenseMarriageService;
use App\Http\Requests\Trade\RenewMarriageLicense\CreateRequest;
use App\Http\Requests\Trade\RenewMarriageLicense\UpdateRequest;



class RenewalLicenseMarriageController extends Controller
{
    protected $commonService;
    protected $renewLicenseMarriage;


    // Constructor for dependency injection
    public function __construct(RenewLicenseMarriageService $renewLicenseMarriage, CommonService $commonService)
    {
        $this->renewLicenseMarriage = $renewLicenseMarriage;
        $this->commonService = $commonService;
    }

    // Display the create form
    public function create()
    {
        // Get active wards and zones from CommonService
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();
        // Return the create view with wards and zones data
        return view('trade.renew-license-marriage.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    // Store the newly created abattoir license
    public function store(CreateRequest $request)
    {

        // Call the store method in the service and get the response
        $renewLicenseMarriage = $this->renewLicenseMarriage->store($request);

        // dd($request);
        // Check if the license was successfully saved
        if ($renewLicenseMarriage[0]) {
            return response()->json([
                'success' => ' Renewal License Marriage saved successfully'
            ]);
        } else {
            return response()->json([
                'error' => $renewLicenseMarriage[1]
            ]);
        }
    }



    public function edit($id)
    {
         $id = decrypt($id);
        $renewLicenseMarriage = RenewMarriageLicense::findOrFail($id);

        $status = Status::where('table_id', $id)
        ->where('service_id', $renewLicenseMarriage->service_id)
        ->first();

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();


        return view('trade.renew-license-marriage.update')->with([
            'renewLicenseMarriage'=>  $renewLicenseMarriage,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }
    public function update(UpdateRequest $request, $id)
    {
        // dd($request->all());
        $renewLicenseMarriage = $this->renewLicenseMarriage->update($request, $id);

        if ($renewLicenseMarriage) {
            return response()->json([
                'success' => 'Renewal License Marriage updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

     public function show($id)
    {
        $data = RenewMarriageLicense::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('trade.renew-license-marriage.renewlicensemarrigecertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = RenewMarriageLicense::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('trade.renew-license-marriage.receipt', ['data' => $data,
           'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }

}
