<?php

namespace App\Http\Controllers\Trade;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\Trade\RenewalLicenseService;
use App\Models\Trade\TradeRenewalLicensePermission;
use App\Http\Requests\Trade\RenewalLicense\CreateRequest;
use App\Http\Requests\Trade\RenewalLicense\UpdateRequest;


class RenewalOfLicenseController extends Controller
{
    protected $renewalLicenseService;
    protected $commonService;

    public function __construct(RenewalLicenseService $renewalLicenseService, CommonService $commonService)
    {
        $this->renewalLicenseService = $renewalLicenseService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('trade.renewal-of-license.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $renewalLicenseService = $this->renewalLicenseService->store($request);

        if ($renewalLicenseService[0]) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $renewalLicenseService[1]
            ]);
        }
    }

    public function edit(string $id)
    {
         $id = decrypt($id);
        $data = TradeRenewalLicensePermission::findOrFail($id);

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

         $status = Status::where('table_id', $id)
        ->where('service_id', $data->service_id)
        ->first();

        return view('trade.renewal-of-license.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $renewalLicenseService = $this->renewalLicenseService->update($request, $id);

        if ($renewalLicenseService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $renewalLicenseService[1]
            ]);
        }
    }

     public function show($id)
    {
        $data = TradeRenewalLicensePermission::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('trade.renewal-of-license.renewalcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = TradeRenewalLicensePermission::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('trade.renewal-of-license.receipt', ['data' => $data,
           'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
