<?php

namespace App\Http\Controllers\Trade;

use App\Models\Status;
use App\Models\SbiPayment;
use App\Models\WaterPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\Trade\RenewalPlumberService;
use App\Models\WaterDepartment\WaterRenewalOfPlumber;
use App\Http\Requests\WaterDepartment\RenewalPlumber\CreateRequest;
use App\Http\Requests\WaterDepartment\RenewalPlumber\UpdateRequest;


class RenewalPlumberLicenseController extends Controller
{
    protected $renewalPlumberService;
    protected $commonService;

    public function __construct(RenewalPlumberService $renewalPlumberService, CommonService $commonService)
    {
        $this->renewalPlumberService = $renewalPlumberService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('trade.renewal-plumber-license.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $renewalPlumberService = $this->renewalPlumberService->store($request);

        if ($renewalPlumberService[0]) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $renewalPlumberService[1]
            ]);
        }
    }

    public function edit(string $id)
    {
        $data = WaterRenewalOfPlumber::findOrFail(decrypt($id));

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $status = Status::where('table_id', decrypt($id))
        ->where('service_id', $data->service_id)
        ->first();

        return view('trade.renewal-plumber-license.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $renewalPlumberService = $this->renewalPlumberService->update($request, $id);

        if ($renewalPlumberService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $renewalPlumberService[1]
            ]);
        }
    }

    public function show($id)
    {
        $data = WaterRenewalOfPlumber::with('user')->findOrFail(decrypt($id));
 $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('trade.renewal-plumber-license.renewal-plumbercertificate', ['data' => $data,'paymentdata'=>$paymentdata ]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = WaterRenewalOfPlumber::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $rate = WaterPayment::where('service_id', $data->service_id)->where('type', $data->Water_Connection_Usage)->value('rate');

        $pdf = SnappyPdf::loadView('trade.renewal-plumber-license.receipt', ['data' => $data,
           'paymentdata' => $paymentdata, 'rate' => $rate]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
