<?php

namespace App\Http\Controllers\Trade;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\Trade\TradeLicense;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\Trade\TradeLicenseService;
use App\Http\Requests\Trade\TradeLicense\CreateRequest;
use App\Http\Requests\Trade\TradeLicense\UpdateRequest;


class TradeLicenseController extends Controller
{
    protected $tradelicenses;
    protected $commonService;

    public function __construct(TradeLicenseService $tradelicenses, CommonService $commonService)
    {
        $this->tradelicenses = $tradelicenses;
        $this->commonService = $commonService;
    }

    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {
    //     //
    // }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('trade.trade-of-license.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        $tradelicenses = $this->tradelicenses->store($request);

        if ($tradelicenses[0]) {
            return response()->json([
                'success' => 'Trade License Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $tradelicenses[1]
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    // public function show(string $id)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {

       $decryptedId = decrypt($id);
       $data = TradeLicense::findOrFail(decrypt($id));

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

         $status = Status::where('table_id', $decryptedId)
        ->where('service_id', $data->service_id)
        ->first();

        return view('trade.trade-of-license.update')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, string $id)
    {
        $tradelicenses = $this->tradelicenses->update($request, $id);

        if ($tradelicenses[0]) {
            return response()->json([
                'success' => 'Trade License Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $tradelicenses[1]
            ]);
        }
    }

    public function show($id)
    {
        $data = TradeLicense::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('trade.trade-of-license.tradelicensecertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }
    /**
     * Remove the specified resource from storage.
     */
    // public function destroy(string $id)
    // {
    //     //
    // }


    public function generateReceipt($id)
    {
        $data = TradeLicense::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('trade.trade-of-license.receipt', ['data' => $data,
           'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
