<?php

namespace App\Http\Controllers\WaterSupplyDepartment;

use App\Models\Status;
use App\Models\SbiPayment;
use App\Models\WaterPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\WaterDepartment\WaterChangeOwnership;
use App\Services\WaterDepartment\ChangeOwnershipService;
use App\Http\Requests\WaterDepartment\ChangeOwnership\CreateRequest;
use App\Http\Requests\WaterDepartment\ChangeOwnership\UpdateRequest;


class ChangeInOwnershipController extends Controller
{
    protected $changeOwnershipService;
    protected $commonService;

    public function __construct(ChangeOwnershipService $changeOwnershipService, CommonService $commonService)
    {
        $this->changeOwnershipService = $changeOwnershipService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $user = Auth::user();

        return view('water-supply-department.change-in-ownership.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $changeOwnershipService = $this->changeOwnershipService->store($request);

        if ($changeOwnershipService[0]) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $changeOwnershipService[1]
            ]);
        }
    }

    public function edit(string $id)
    {
        $data = WaterChangeOwnership::findOrFail(decrypt($id));

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $status = Status::where('table_id', decrypt($id))
        ->where('service_id', $data->service_id)
        ->first();

        return view('water-supply-department.change-in-ownership.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $changeOwnershipService = $this->changeOwnershipService->update($request, $id);

        if ($changeOwnershipService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $changeOwnershipService[1]
            ]);
        }
    }

    public function show($id)
    {
        $data = WaterChangeOwnership::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('water-supply-department.change-in-ownership.changeinownershipcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = WaterChangeOwnership::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();

        $rate = WaterPayment::where('service_id', $data->service_id)->where('type', $data->Water_Connection_Usage)->value('rate');

        $pdf = SnappyPdf::loadView('water-supply-department.change-in-ownership.receipt', ['data' => $data,

        'paymentdata' => $paymentdata, 'rate' => $rate]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
