<?php

namespace App\Http\Controllers\WaterSupplyDepartment;

use App\Models\Status;
use App\Models\SbiPayment;
use App\Models\WaterPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\WaterDepartment\WaterDisconnectSupply;
use App\Services\WaterDepartment\DisconnectSupplyService;
use App\Http\Requests\WaterDepartment\DisconnectSupply\CreateRequest;
use App\Http\Requests\WaterDepartment\DisconnectSupply\UpdateRequest;


class DisconnectWaterSupplyController extends Controller
{
    protected $disconnectSupplyService;
    protected $commonService;

    public function __construct(DisconnectSupplyService $disconnectSupplyService, CommonService $commonService)
    {
        $this->disconnectSupplyService = $disconnectSupplyService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $user = Auth::user();

        return view('water-supply-department.disconnect-water-supply.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $disconnectSupplyService = $this->disconnectSupplyService->store($request);

        if ($disconnectSupplyService[0]) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $disconnectSupplyService[1]
            ]);
        }
    }

    public function edit(string $id)
    {
        $data = WaterDisconnectSupply::findOrFail(decrypt($id));

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $status = Status::where('table_id', decrypt($id))
        ->where('service_id', $data->service_id)
        ->first();

        return view('water-supply-department.disconnect-water-supply.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' =>$status,
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $disconnectSupplyService = $this->disconnectSupplyService->update($request, $id);

        if ($disconnectSupplyService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $disconnectSupplyService[1]
            ]);
        }
    }

     public function show($id)
    {
        $data = WaterDisconnectSupply::with('user')->findOrFail(decrypt($id));
$paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('water-supply-department.disconnect-water-supply.disconnectwatercertificate', ['data' => $data,'paymentdata'=>$paymentdata]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = WaterDisconnectSupply::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();

        $rate = WaterPayment::where('service_id', $data->service_id)->where('type', $data->Water_Connection_Usage)->value('rate');

        $pdf = SnappyPdf::loadView('water-supply-department.disconnect-water-supply.receipt', ['data' => $data,
           'paymentdata' => $paymentdata, 'rate' => $rate]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }

}
