<?php

namespace App\Http\Controllers\WaterSupplyDepartment;

use App\Models\Status;
use App\Models\SbiPayment;
use App\Models\WaterPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\WaterDepartment\Illegalwaterconnection;
use App\Services\WaterDepartment\IllegalWaterConnectionService;
use App\Http\Requests\WaterDepartment\IllegalWaterConnection\CreateRequest;
use App\Http\Requests\WaterDepartment\IllegalWaterConnection\UpdateRequest;


class IllegalWaterConnectionController extends Controller
{
    protected $illegalWaterConnectionService;
    protected $commonService;

    public function __construct(IllegalWaterConnectionService $illegalWaterConnectionService, CommonService $commonService)
    {
        $this->illegalWaterConnectionService = $illegalWaterConnectionService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $user = Auth::user();

        return view('water-supply-department.illegal-water-connection.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user
        ]);
    }


    public function store(CreateRequest $request)
    {
        $illegalWaterConnectionService = $this->illegalWaterConnectionService->store($request);

        if ($illegalWaterConnectionService[0]) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $illegalWaterConnectionService[1]
            ]);
        }
    }


    public function edit(string $id)
    {
        $data = Illegalwaterconnection::findOrFail(decrypt($id));

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        $status = Status::where('table_id', decrypt($id))
        ->where('service_id', $data->service_id)
        ->first();

        return view('water-supply-department.illegal-water-connection.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $illegalWaterConnectionService = $this->illegalWaterConnectionService->update($request, $id);

        if ($illegalWaterConnectionService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $illegalWaterConnectionService[1]
            ]);
        }
    }

    public function show($id)
    {
        $data = Illegalwaterconnection::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('water-supply-department.illegal-water-connection.illegalwaterconnectioncertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = Illegalwaterconnection::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $rate = 0;
        if ($data->Water_Connection_Size == '1') {
            $rate = 151588;
        } elseif ($data->Water_Connection_Size == '1/5') {
            $rate = 78765;
        }

        $pdf = SnappyPdf::loadView('water-supply-department.illegal-water-connection.receipt', ['data' => $data,
           'paymentdata' => $paymentdata, 'rate' => $rate]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }


}
