<?php

namespace App\Http\Controllers\WaterSupplyDepartment;

use App\Models\Status;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\WaterDepartment\WaterTaxBill;
use App\Models\SbiPayment;
use App\Services\WaterDepartment\TaxBillService;
use App\Http\Requests\WaterDepartment\TaxBill\CreateRequest;
use App\Http\Requests\WaterDepartment\TaxBill\UpdateRequest;


class WaterTaxController extends Controller
{
    protected $taxBillService;
    protected $commonService;

    public function __construct(TaxBillService $taxBillService, CommonService $commonService)
    {
        $this->taxBillService = $taxBillService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $user = Auth::user();

        return view('water-supply-department.water-tax-bill.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $taxBillService = $this->taxBillService->store($request);

        if ($taxBillService[0]) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $taxBillService[1]
            ]);
        }
    }

    public function edit(string $id)
    {
        $data = WaterTaxBill::findOrFail(decrypt($id));

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $status = Status::where('table_id', decrypt($id))
        ->where('service_id', $data->service_id)
        ->first();


        return view('water-supply-department.water-tax-bill.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $taxBillService = $this->taxBillService->update($request, $id);

        if ($taxBillService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $taxBillService[1]
            ]);
        }
    }

     public function show($id)
    {
        $data = WaterTaxBill::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('water-supply-department.water-tax-bill.watertaxbillcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = WaterTaxBill::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('water-supply-department.water-tax-bill.receipt', ['data' => $data,
           'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }



}
