<?php

namespace App\Http\Controllers\WaterSupplyDepartment;

use App\Models\Status;




use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\WaterDepartment\WaterUnavailabilitySupply;
use App\Services\WaterDepartment\WaterUnavailabilitySupplyService;
use App\Http\Requests\WaterDepartment\WaterUnavailabilitySupply\CreateRequest;
use App\Http\Requests\WaterDepartment\WaterUnavailabilitySupply\UpdateRequest;
use App\Models\SbiPayment;

class WaterUnavailabilitySupplyController extends Controller
{
    //
    protected $WaterUnavailabilitySupplyService;
    protected $commonService;

    public function __construct(WaterUnavailabilitySupplyService $WaterUnavailabilitySupplyService, CommonService $commonService)
    {
        $this->WaterUnavailabilitySupplyService = $WaterUnavailabilitySupplyService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $user = Auth::user();

        return view('water-supply-department.unavalibality-water-supply.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user
        ]);
    }

    public function store(CreateRequest $request)
    {
        $WaterUnavailabilitySupplyService = $this->WaterUnavailabilitySupplyService->store($request);

        if ($WaterUnavailabilitySupplyService[0]) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $WaterUnavailabilitySupplyService[1]
            ]);
        }
    }

    public function edit(string $id)
    {
        $data = WaterUnavailabilitySupply::findOrFail(decrypt($id));

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $status = Status::where('table_id', decrypt($id))
        ->where('service_id', $data->service_id)
        ->first();

        return view('water-supply-department.unavalibality-water-supply.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $WaterUnavailabilitySupplyService = $this->WaterUnavailabilitySupplyService->update($request, $id);

        if ($WaterUnavailabilitySupplyService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $WaterUnavailabilitySupplyService[1]
            ]);
        }
    }

    public function show($id)
    {
        $data = WaterUnavailabilitySupply::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('water-supply-department.unavalibality-water-supply.noduecertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = WaterUnavailabilitySupply::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('water-supply-department.unavalibality-water-supply.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
