<?php

namespace App\Http\Controllers\fireDepartment;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\FireDepartment\FireFinalNoObjection;
use App\Services\FireDepartment\FinalNoObjectionService;
use App\Http\Requests\FireDepartment\FinalNoObjection\CreateRequest;
use App\Http\Requests\FireDepartment\FinalNoObjection\UpdateRequest;

class FinalFireNoObjectionController extends Controller
{
    protected $finalNoObjectionService;
    protected $commonService;

    public function __construct(FinalNoObjectionService $finalNoObjectionService , CommonService $commonService)
    {
        $this->finalNoObjectionService = $finalNoObjectionService;
        $this->commonService = $commonService;
    }

    public function create()
    {
          $wards = $this->commonService->getActiveWard();

        return view('FireDepartment.FinalNoObjectionCertificate.create', compact('wards'));
    }

    public function store(CreateRequest $request)
    {
        $finalNoObjectionService = $this->finalNoObjectionService->store($request);

        if ($finalNoObjectionService) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

    public function edit(string $id)
    {

        $id = decrypt($id);
        $data = FireFinalNoObjection::findOrFail($id);
        $status = Status::where('table_id', $id)
            ->where('service_id', $data->service_id)
            ->first();
        $wards = $this->commonService->getActiveWard();

        return view('FireDepartment.FinalNoObjectionCertificate.edit', compact('data','status','wards'));
    }

    public function update(UpdateRequest $request, string $id)
    {

        $finalNoObjectionService = $this->finalNoObjectionService->update($request, $id);

        if ($finalNoObjectionService) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

     public function show($id)
    {
        $data = FireFinalNoObjection::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('FireDepartment.FinalNoObjectionCertificate.finalnocertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

      public function generateReceipt($id)
    {
        $data = FireFinalNoObjection::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('FireDepartment.FinalNoObjectionCertificate.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
