<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;

class UpdateApprovalRequestHierarchiesRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            // 'requester_department_id' => 'required|exists:departments,id',
            // 'service_id' => 'required|unique:approval_request_hierarchies,service_id,' . $this->input('edit_model_id'),

            // Approver fields
            'first_approver_designation_id' => 'nullable',
            'first_department_id' => 'nullable|exists:departments,id',

            'second_approver_designation_id' => 'nullable',
            'second_department_id' => 'nullable|exists:departments,id',

            'third_approver_designation_id' => 'nullable',
            'third_department_id' => 'nullable|exists:departments,id',

            'fourth_approver_designation_id' => 'nullable',
            'fourth_department_id' => 'nullable|exists:departments,id',

            'five_approver_designation_id' => 'nullable',
            'five_department_id' => 'nullable|exists:departments,id',

            'six_approver_designation_id' => 'nullable',
            'six_department_id' => 'nullable|exists:departments,id',

            'seven_approver_designation_id' => 'nullable',
            'seven_department_id' => 'nullable|exists:departments,id',

            'eight_approver_designation_id' => 'nullable',
            'eight_department_id' => 'nullable|exists:departments,id',
        ];
    }

    public function messages(): array
    {
        return [
            'requester_department_id.required' => 'The requester department is required.',
            'requester_department_id.exists' => 'The selected requester department does not exist.',
            'service_id.required' => 'The service is required.',
            'service_id.unique' => 'The service has already been used.',

            'first_department_id.exists' => 'The selected department for Approver 1 does not exist.',
            'first_approver_designation_id.exists' => 'The selected designation for Approver 1 does not exist.',
            'second_department_id.exists' => 'The selected department for Approver 2 does not exist.',
            'second_approver_designation_id.exists' => 'The selected designation for Approver 2 does not exist.',
            'third_department_id.exists' => 'The selected department for Approver 3 does not exist.',
            'third_approver_designation_id.exists' => 'The selected designation for Approver 3 does not exist.',
            'fourth_department_id.exists' => 'The selected department for Approver 4 does not exist.',
            'fourth_approver_designation_id.exists' => 'The selected designation for Approver 4 does not exist.',
            'five_department_id.exists' => 'The selected department for Approver 5 does not exist.',
            'five_approver_designation_id.exists' => 'The selected designation for Approver 5 does not exist.',
            'six_department_id.exists' => 'The selected department for Approver 6 does not exist.',
            'six_approver_designation_id.exists' => 'The selected designation for Approver 6 does not exist.',
            'seven_department_id.exists' => 'The selected department for Approver 7 does not exist.',
            'seven_approver_designation_id.exists' => 'The selected designation for Approver 7 does not exist.',
            'eight_department_id.exists' => 'The selected department for Approver 8 does not exist.',
            'eight_approver_designation_id.exists' => 'The selected designation for Approver 8 does not exist.',
        ];
    }

    public function withValidator(Validator $validator): void
    {
        $validator->after(function (Validator $validator) {
            $designationFields = [
                'first_approver_designation_id',
                'second_approver_designation_id',
                'third_approver_designation_id',
                'fourth_approver_designation_id',
                'five_approver_designation_id',
                'six_approver_designation_id',
                'seven_approver_designation_id',
                'eight_approver_designation_id'
            ];

            $departmentFields = [
                'first_department_id',
                'second_department_id',
                'third_department_id',
                'fourth_department_id',
                'five_department_id',
                'six_department_id',
                'seven_department_id',
                'eight_department_id'
            ];

            $hasAtLeastOneApprover = false;

            for ($i = 0; $i < 8; $i++) {
                $designation = $this->input($designationFields[$i]);
                $department = $this->input($departmentFields[$i]);

                // If either is filled, both must be filled
                if ($designation && !$department) {
                    $validator->errors()->add($departmentFields[$i], 'Department is required.');
                }
                if ($department && !$designation) {
                    $validator->errors()->add($designationFields[$i], 'Designation is required.');
                }

                // Track if at least one full approver exists
                if ($designation && $department) {
                    $hasAtLeastOneApprover = true;
                }
            }

            if (!$hasAtLeastOneApprover) {
                $validator->errors()->add('approver_required', 'At least one approver (department + designation) must be provided.');
            }
        });
    }
}
