<?php

namespace App\Http\Requests\ConstructionDepartment\DrainageConnection;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'applicant_name' => 'required',
            'applicant_area_details' => 'nullable',
            'applicant_full_address' => 'nullable',
            'zone' => 'nullable',
            'ward_area' => 'nullable',
            'ward' => 'nullable',
            'mobile_no' => 'required|min:10|max:10',
            'aadhar_no' => 'required|min:12|max:12',
            'email_id' => 'required',
            'address' => 'required',
            'property_number' => 'required',
            'property_usage' => 'nullable',
            'connection_size_inches' => 'nullable',
            'construction_date' => 'nullable',
            'flat_assesment_date' => 'nullable',
            'flat_map_date' => 'nullable',
            'current_water_tax_amount' => 'nullable',
            'current_tax_paid_date' => 'nullable',
            'lichpit_count' => 'required',
            'is_toilet_available' => 'required',
            'total_residencial_people_count' => 'nullable',
            'total_renter_count' => 'nullable',
            'connection_size_feet' => 'nullable',
            'connection_count' => 'nullable',
           // 'oc_cc_docs' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'oc_cc_docs' => 'required',
            'upload_prescribed_formats' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
           // 'upload_no_dues_certificates' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
           'upload_no_dues_certificates' => 'nullable',
            'upload_property_ownerships' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'is_correct_info' => 'required',

            'Connection_Type' => 'nullable',
            'House_Number' => 'nullable',
            'Property_Owner_Name' => 'nullable',
            'Full_Address_Of_The_Property' => 'nullable',
            'Water_Connection_Size' => 'nullable',
            'Water_Connection_Usage' => 'nullable',
            'OutstandingAmt' => 'nullable',

        ];
    }

    public function messages()
    {
        return [
            'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
