<?php

namespace App\Http\Requests\ConstructionDepartment\RoadCutting;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'applicant_type' => 'required',
            'applicant_name' => 'required',
            'applicant_full_address' => 'required',
            'zone' => 'nullable',
            'ward_area' => 'nullable',
            'company_name' => 'required',
            //'designation' => 'required',
            'mobile_no' => 'required|min:10|max:10',
            'email_id' => 'required',
            'aadhar_no' => 'nullable|min:12|max:12',
            'road_cutting_purpose' => 'required',
            'road_length' => 'required',
            'no_of_location' => 'required',
            'road_cutting_address' => 'required',
            'location_size' => 'required',
            'no_duct' => 'required',
            'roadtype' => 'required',
            'no_chamber' => 'required',
            'upload_prescribed_formats' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'upload_no_dues_certificates' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'upload_gov_instructed_docs' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'upload_related_docs' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'upload_gps_docs' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'is_correct_info' => 'required',
           // 'roadtype' => 'required|array',
           // 'roadtype.*' => 'required|integer',
            //'startpoint' => 'required|array',
           // 'startpoint.*' => 'required|string',
            //'endpoint' => 'required|array',
           // 'endpoint.*' => 'required|string',
            //'road_length' => 'required|array',
            //'road_length.*' => 'required|numeric',
           // 'defect_factor' => 'nullable|array',
            // 'defect_factor.*' => 'nullable|integer'
            //'defect_factor.*' => 'nullable|numeric'

        ];
    }

    public function messages()
    {
        return [
            'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
