<?php

namespace App\Http\Requests\ConstructionDepartment\RoadCutting;

use DB;
use App\Models\Status;
use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;
use App\Models\ConstructionDepartment\ConstructionRoadCutting;

class UpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $construction_id = $this->route('construction_road_cutting');
        $existing = ConstructionRoadCutting::find($construction_id);

        // Check if ward changed
        $wardChanged = $existing && $this->ward_area != $existing->ward_area;

        // Get pay status from DB
        $payStatus = 0;
        if ($existing) {
            $payStatus = DB::table('sbi_payments') // replace with actual table
                ->where('service_id', $existing->service_id)
                ->where('table_id', $existing->id)
                ->value('status') ?? 0;
        }

        $status = 0;
        if ($existing) {
         $status = Status::where('table_id', $existing->id)
            ->where('service_id', $existing->service_id)
            ->value('receipt_status') ?? 0;
           
          
        }



        $rules = [];

        if (Auth::check() && (Auth::user()->hasRole('Clerk') || Auth::user()->hasRole('JuniorEngineer'))) {
            $rules = [
                'ward_area' => 'required',
                'roadtype.*' => $wardChanged ? 'nullable' :'required',
                'startpoint.*' => $wardChanged ? 'nullable' :'required',
                'endpoint.*' => $wardChanged ? 'nullable' :'required',
                'road_length.*' => $wardChanged ? 'nullable|numeric' : 'required|numeric',
                'defect_factor.*' => $wardChanged ? 'nullable' : 'required',
                'no_of_location' => 'required',
                'no_duct' => 'required',
                'no_chamber' => 'required',
                'upload_photos'=>'nullable|file|mimes:pdf,png,jpg,jpeg|max:2048',
            ];

            // Add start/end date rules if Clerk and payStatus is 1
            if (Auth::user()->hasRole('Clerk') && $payStatus == 1 || $status==1) {
                $rules['start_date'] = 'required|date';
                $rules['end_date'] = 'required|date|after_or_equal:start_date';
            }
        }

        // Common rules for all users
        $commonRules = [
            'applicant_name' => 'required',
            'applicant_full_address' => 'required',
            'zone' => 'nullable',
            'ward' => 'nullable',
            'company_name' => 'required',
            'designation' => 'required',
            'mobile_no' => 'required|min:10|max:10',
            'email_id' => 'required',
            'aadhar_no' => 'nullable|min:12|max:12',
            'road_cutting_purpose' => 'required',
            'road_length' => 'required',
            'no_of_location' => 'required',
            'road_cutting_address' => 'required',
            'location_size' => 'required',
            'upload_prescribed_formats' => 'nullable|file|mimes:pdf,png,jpg,jpeg|max:2048',
            'upload_no_dues_certificates' => 'nullable|file|mimes:pdf,png,jpg,jpeg|max:2048',
            'upload_gov_instructed_docs' => 'nullable|file|mimes:pdf,png,jpg,jpeg|max:2048',
            'upload_related_docs' => 'nullable|file|mimes:pdf,png,jpg,jpeg|max:2048',
            'upload_gps_docs' => 'nullable|file|mimes:pdf,png,jpg,jpeg|max:2048',
        ];

        // Merge rules
        return array_merge($rules, $commonRules);
    }

    public function messages()
    {
        return [
            'roadtype.*.required' => 'Please Select Road Type',
            'startpoint.*.required' => 'Please Enter Start Point',
            'endpoint.*.required' => 'Please Enter End Point',
            'road_length.*.required' => 'Please Enter Road Length',
            'defect_factor.*.required' => 'Please Select Defect Liability Factor',
        ];
    }
}
