<?php

namespace App\Http\Requests\DemolishingProperty;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            // 'f_name' => 'required',
            // 'm_name' => 'required',
            // 'l_name' => 'required|min:10|max:10',
            // 'zone' => 'nullable',
            // 'marathi_f_name' => 'required',
            // 'marathi_m_name' => 'required|min:10|max:10',
            // 'marathi_l_name' => 'required|min:12|max:12',
            // 'email' => 'required',
            // 'address' => 'required',
            // 'marathi_address' => 'required',
            // 'purpose' => 'required',
            // 'marathi_purpose' => 'required',

            'f_name' => 'required',
            'address' => 'required',
            'mobile_num' => 'required|digits:10',
            'email' => 'required|email',
            'aadhar_num' => 'nullable|digits:12',
            'property_number' => 'required',
            'property_owner_name' => 'required',
            'property_address' => 'required',
            'ward' => 'required',
            'zone' => 'required',
            'survey_number' => 'nullable',
            'm_name' => 'required',
            'property_area' => 'required',
            'property_usage' => 'required',
            'l_name' => 'required',
            'no_dues_certificate' => 'required|file|mimes:png,jpg,pdf,jpeg',
            'application_file' => 'required|file|mimes:png,jpg,pdf,jpeg',
            'marathi_purpose' => 'required',
            'is_correct_info' => 'required',

        ];
    }

    public function messages()
    {
        return [
            'f_name.required' => 'This field is required',
            'address.required' => 'This field is required',
            'mobile_num.required' => 'This field is required',
            'email.required' => 'This field is required',
            'aadhar_num.digits' => 'Please enter valid aadhaar number',
            'property_number.required' => 'This field is required',
            'property_owner_name.required' => 'This field is required',
            'property_address.required' => 'This field is required',
            'ward.required' => 'This field is required',
            'zone.required' => 'This field is required',
            'survey_number.required' => 'This field is required',
            'm_name.required' => 'This field is required',
            'property_area.required' => 'This field is required',
            'property_usage.required' => 'This field is required',
            'l_name.required' => 'This field is required',
            'no_dues_certificate.required' => 'This field is required',
            'application_file.required' => 'This field is required',
            'marathi_purpose.required' => 'This field is required',
            'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
