<?php

namespace App\Http\Requests\InsuranceOfBirthCertificate\InsuranceOfDeath;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'surname'=>'required',
            'name'=>'required',
            'father_name'=>'required',
            'address'=>'required',
            'society_name'=>'required',
            'block_no'=>'required',
            'road_name'=>'required',
            'place'=>'required',
            'pincode'=>'required|string|min:6|max:6|regex:/^[0-9]{6}$/',
            // 'ward_no'=>'required',
            'mbmc_elec_ward_no'=>'required',
            'mobile_no'=>'required',
            'date_of_death'=>'required',
            'name_of_deceased'=>'required',
            'name_in_english'=>'required',
            'gender'=>'required',
            'age'=>'required',
            'place_of_death'=>'required',
            'permanenent_address'=>'required',
            'no_of_certificate'=>'required'
        ];
    }
}
