<?php

namespace App\Http\Requests\InsuranceOfBirthCertificate\InsuranceofBirth;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'surname' => ['required', 'regex:/^[a-zA-Z\s]+$/'],
            'name' => ['required', 'regex:/^[a-zA-Z\s]+$/'],
            'father_name' => ['required', 'regex:/^[a-zA-Z\s]+$/'],
            'address' => 'required',
            'room_name' => 'required',
            'ward' => 'required',
            'pincode' => 'required|string|min:6|max:6|regex:/^[0-9]{6}$/',
            'ward_no' => 'required',
            'mbmc_elec_ward_no' => 'required',
            'mobile_no' => 'required|string|min:10|max:10|regex:/^[0-9]{10}$/',
            'mother_full_name' => ['required', 'regex:/^[a-zA-Z\s]+$/'],
            'father_full_name' => ['required', 'regex:/^[a-zA-Z\s]+$/'],
            'mother_father_address' => 'required',
            'birth_place' => ['required', 'regex:/^[a-zA-Z\s]+$/'],
            'birth_date' => 'required|date',
            'block_no' => 'required',
            'road_name' => 'required',
            'gender' => 'required',
            'child_name' => ['required', 'regex:/^[a-zA-Z\s]+$/'],
            'no_of_certificate' => 'required',
        ];
    }

    /**
     * Get custom error messages for validation.
     *
     * @return array
     */
    public function messages(): array
    {
        return [
            'surname.required' => 'The surname field is required.',
            'surname.regex' => 'The surname must only contain letters and spaces.',
            'pincode_no.digits' => 'The pincode must be 6 digits long.',
            'mobile_no.digits' => 'The contact number must be 10 digits long.',
            'mobile_no.numeric' => 'The contact number must contain only numbers.',
            'birth_date.date' => 'The birth date must be a valid date.',
        ];
    }
}
