<?php

namespace App\Http\Requests\MedicalHealth\CityClean;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
           'applicant_name' => 'required',
            'applicant_address' => 'required',
            'mobile_no' => 'required|max:10|min:10',
            'email' => 'nullable',
            'aadhar_num' => 'required|max:12|min:12',
            'address' => 'required',
            'geo_photo' => 'required',
            // 'is_correct_info' => 'required'
        ];
    }
    public function messages()
    {
        return [
            //   'is_correct_info.required' => 'Please Accept Declaration',
            'applicant_name' => 'Please Enter Full Name ',
            'applicant_address' => 'Please Enter Applicant Address',
            'email' => 'Please Enter Email Id',
            'address' => 'Please Enter Address',
            'mobile_no' => 'Please Enter Mobile Number  an min 10 digit or max 10 digit',
            'aadhar_num' => 'Please Enter Aadhar Number an min 12 digit or max 12 digit',
            'geo_photo' =>'please upload Geo tag photos '
        ];
    }
}
