<?php

namespace App\Http\Requests\MedicalHealth\GutterCover;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'application_name' => 'required',
            'area' => 'required',
            'location' => 'required',
            'landmark' => 'required',
            'email' => 'required',
            'ward_area' => 'required',
            'details' => 'required',
            'pincode' => 'required|digits:6',
            'gpsphotos' => 'required',
            'mobile_no' => 'required|max:10|min:10',
            'adhaarno' => 'required|max:12|min:12',
            'is_correct_info' => 'required'
        ];
    }

    public function messages()
    {
        return [
            'is_correct_info.required' => 'Please Accept Declaration',
            'application_name.required' => 'Please Enter Application Name',
            'area.required' => 'Please Enter Area',
            'location.required' => 'Please Enter the Location',
            'landmark.required' => 'Please Enter the Landmark',
            'email.required' => 'Please Enter the Email',
            'ward_area.required' => 'Please Select Ward',
            'details.required' => 'Please Enter the Details',
            'pincode.required' => 'Please Enter Pincode',
            'gpsphoto.required' => 'Please Choose The GPS Photo',
            'mobile_no.required' => 'Please Enter Mobile Number',
            'adhaarno.required' => 'Please Enter Adhaar Number',
        ];
    }
}
