<?php

namespace App\Http\Requests\MedicalHealth\GutterCover;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'application_name' => 'nullable',
            'area' => 'nullable',
            'location' => 'nullable',
            'landmark' => 'nullable',
            'email' => 'nullable',
            'ward' => 'nullable',
            'details' => 'nullable',
            'pincode' => 'nullable',
            'gpsphoto' => 'nullable',
            'mobile_no' => 'nullable|max:10|min:10',
            'adhaarno' => 'nullable|max:12|min:12',
            // 'is_correct_info' => 'nullable'
        ];
    }
    public function messages()
    {
        return [
            //   'is_correct_info.nullable' => 'Please Accept Declaration',
            'application_name.nullable' => 'Please Enter Application Name',
            'area.nullable' => 'Please Enter Area',
            'location.nullable' => 'Please Enter the Location',
            'landmark.nullable' => 'Please Enter the Landmark',
            'email.nullable' => 'Please Enter the Email',
            'ward.nullable' => 'Please Select Ward',
            'details.nullable' => 'Please Enter the Details',
            'pincode.nullable' => 'Please Enter Pincode',
            'gpsphoto.nullable' => 'Please Choose The GPS Photo',
            'mobile_no.nullable' => 'Please Enter Mobile Number',
            'adhaarno.nullable' => 'Please Enter Adhaar Number',
        ];
    }
}
