<?php

namespace App\Http\Requests\PropertyTax;

use Illuminate\Foundation\Http\FormRequest;

class NoDueCertificateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string => '',
     *  \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        if ($this->id && $this->id != "") {
            return [
                'upic_id' => 'nullable',
                'applicant_name_eng' => 'required',
                'applicant_name_mar' => 'required',
                'applicant_mobile_no' => 'required|min:10|max:10',
                'email_id' => 'required',
                // 'aadhar_no' => 'nullable|min:12|max:12',
                'zone' => 'nullable',
                'ward_area' => 'required',
                'connection_no'=>'required',
                'owner_name'=>'required',
                'owner_full_add'=>'required',
                'land_mark'=>'required',
                // 'receipt_doc'=>'required',
                'property_address' => 'required',
                // 'house_no' => 'required',
                'property_no' => 'required',
                'annual_period' => 'required',
                'connection_no'=>'required',
                'owner_name'=>'required',
                'owner_full_add'=>'required',
                'land_mark'=>'required',
                // 'receipt_doc'=>'required',
                'uploaded_applications' => 'nullable',
                // 'is_correct_info' => 'required',
                // 'receipt_doc'=>'required'
            ];
        } else {
            return [
                'upic_id' => 'nullable',
                'applicant_name_eng' => 'required',
                'applicant_name_mar' => 'required',
                'applicant_mobile_no' => 'required|min:10|max:10',
                'email_id' => 'required',
                // 'aadhar_no' => 'nullable|min:12|max:12',
                'zone' => 'nullable',
                'ward_area' => 'nullable',
                'property_address' => 'required',
                // 'house_no' => 'required',
                'property_no' => 'required',
                'annual_period' => 'required',
                'uploaded_applications' => 'nullable',
                // 'receipt_doc'=>'required',
                // 'is_correct_info' => 'required',
                // 'receipt_doc'=>'required'
            ];
        }
    }

    public function messages()
    {
        return [
            'applicant_name_eng.required' => 'Please enter address in english',
            'applicant_name_mar.required' => 'Please enter address in marathi',
            'applicant_mobile_no.required' => 'Please enter mobile no',
            'email_id.required' => 'Please enter email',
            // 'aadhar_no.required' => 'Please enter aadhar no',
            'zone.nullable' => 'Please select zone',
            'ward_area.nullable' => 'Please select ward',
            'property_address.required' => 'Please enter property address',
            // 'house_no.required' => 'Please enter house no',
            'property_no.required' => 'Please enter property number',
            'annual_period.required' => 'Please enter annual period',
            // 'uploaded_applications.nullable' => 'Please select file',
            // 'uploaded_applications.mimes' => 'File should be png, jpg and pdf type',
            // 'uploaded_applications.max' => 'File should be less than 2mb',
            // 'receipt_doc.required'=>'required',
            // 'is_correct_info.required' => 'Please accept declaration',
            // 'receipt_doc.required'=>'please select file'
        ];
    }
}
