<?php

namespace App\Http\Requests\PropertyTax;

use Illuminate\Foundation\Http\FormRequest;

class PropertyDivision extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'propno' => 'required|string',
            'applicantname' => 'required|string|max:200',
            'address' => 'required|string|max:200',
            'mobile_no' => 'required|digits:10',
            'adhaarno' => 'required|digits:12',
            'email' => 'required|email',
            'property_name' => 'required|string|max:200',
            'property_address' => 'required',
            'property_num' => 'required',
            'property_area' => 'required',
            'flat_no' => 'required',
            'ward' => 'required',
            'zone' => 'required',
            // 'outstanding_amt' => 'required',
            'upload_prescribed_formatss' => 'required|file|mimes:png,jpg,pdf,jpeg|max:2048',
            'upload_no_due_docs' => 'required|file|mimes:png,jpg,pdf,jpeg|max:2048',
            'owner_docs' => 'required|file|mimes:png,jpg,pdf,jpeg|max:2048',
            'doc_upload' => 'nullable|file|mimes:png,jpg,pdf,jpeg|max:2048',
            'is_correct_info' => 'required'
        ];
    }


    public function messages(): array
    {
        return [
            'propno.required' => 'Please enter the property number',
            'applicantname.required' => 'Applicant name is required.',
            'address.required' => 'Address is required.',

            'mobile_no.required' => 'Mobile number is required.',
            'mobile_no.digits' => 'Mobile number must be exactly 10 digits.',

            'adhaarno.required' => 'Aadhaar number is required.',
            'adhaarno.digits' => 'Aadhaar number must be exactly 12 digits.',

            'email.required' => 'Email is required.',
            'email.email' => 'Please enter a valid email address.',

            'property_name.required' => 'Property name is required.',
            'property_address.required' => 'Property address is required.',
            'property_num.required' => 'Property number is required.',
            'property_area.required' => 'Property area is required.',
            'flat_no.required' => 'Flat number is required.',
            'ward.required' => 'Ward is required.',
            'zone.required' => 'Zone is required.',
            // 'outstanding_amt.required' => 'Outstanding amount is required.',

            'upload_prescribed_formatss.required' => 'Please upload the prescribed format file.',
            'upload_prescribed_formatss.file' => 'The prescribed format must be a valid file.',
            'upload_prescribed_formatss.mimes' => 'Only PNG, JPG, JPEG, or PDF files are allowed.',
            'upload_prescribed_formatss.max' => 'File size must not exceed 2MB.',

            'upload_no_due_docs.required' => 'Please upload the no dues document.',
            'upload_no_due_docs.file' => 'The no dues document must be a valid file.',
            'upload_no_due_docs.mimes' => 'Only PNG, JPG, JPEG, or PDF files are allowed.',
            'upload_no_due_docs.max' => 'File size must not exceed 2MB.',

            'owner_docs.required' => 'Please upload the owner document.',
            'owner_docs.file' => 'The owner document must be a valid file.',
            'owner_docs.mimes' => 'Only PNG, JPG, JPEG, or PDF files are allowed.',
            'owner_docs.max' => 'File size must not exceed 2MB.',

            'doc_upload.required' => 'Please upload the required document.',
            'doc_upload.file' => 'The uploaded document must be a valid file.',
            'doc_upload.mimes' => 'Only PNG, JPG, JPEG, or PDF files are allowed.',
            'doc_upload.max' => 'File size must not exceed 2MB.',

            'is_correct_info.required' => 'Please accept the declaration.',
        ];
    }
}
