<?php

namespace App\Http\Requests\Pwd\GrantingTelecom;

use Illuminate\Support\Facades\DB;
use App\Models\Status;
use App\Models\Pwd\GrantingTelecom;
use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $granting_id = $this->route('grant_telecome');
        $existing = GrantingTelecom::find($granting_id);

        // Check if ward changed
        $wardChanged = $existing && $this->ward_area != $existing->ward_area;

        // Payment Status
        $payStatus = 0;
        if ($existing) {
            $payStatus = DB::table('sbi_payments')
                ->where('service_id', $existing->service_id)
                ->where('table_id', $existing->id)
                ->value('status') ?? 0;
        }

         $status = 0;
        if ($existing) {
         $status = Status::where('table_id', $existing->id)
            ->where('service_id', $existing->service_id)
            ->value('receipt_status') ?? 0;
        }



        /* --------------------------------------------
            CASE 1 : Clerk / JuniorEngineer Validation
        -------------------------------------------- */
        if (
            Auth::check() &&
            (Auth::user()->hasRole('Clerk') || Auth::user()->hasRole('JuniorEngineer'))
        ) {

            // Base rules
            $rules = [
                'ward_area' => 'required',

                'roadtype.*'      => $wardChanged ? 'nullable' : 'required',
                'startpoint.*'    => $wardChanged ? 'nullable' : 'required',
                'endpoint.*'      => $wardChanged ? 'nullable' : 'required',
                'road_length.*'   => $wardChanged ? 'nullable|numeric' : 'required|numeric',
                'defect_factor.*' => $wardChanged ? 'nullable' : 'required',
            ];

            // Clerk + payStatus = 1 → require start/end date
            if (Auth::user()->hasRole('Clerk') && $payStatus == 1 || $status==1) {
               $rules['ward_area'] = 'nullable';
                $rules['start_date'] = 'required|date';
                $rules['end_date']   = 'required|date|after_or_equal:start_date';
            }

            return $rules;
        }

        /* --------------------------------------------
            CASE 2 : Other Roles Validation (Normal)
        -------------------------------------------- */
        return [
            'f_name'       => 'required',
            'm_name'       => 'required',
            'l_name'       => 'required',
            'zone'         => 'nullable',
            'aadhar_num'   => 'required|min:12|max:12',
            'email'        => 'required',
            'address'      => 'required',
            'property_num' => 'required',
            'digging_size' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'f_name.required'        => 'Please Enter First Name',
            'm_name.required'        => 'Please Enter Middle Name',
            'l_name.required'        => 'Please Enter Last Name',
            'aadhar_num.required'    => 'Please Enter Aadhar Number',
            'aadhar_num.min'         => 'Aadhar Number must be 12 digits',
            'aadhar_num.max'         => 'Aadhar Number must be 12 digits',
            'email.required'         => 'Please Enter Email',
            'address.required'       => 'Please Enter Address',
            'property_num.required'  => 'Please Enter Property Number',
            'digging_size.required'  => 'Please Enter Road Digging Size',

            'roadtype.*.required'      => 'Please Select Road Type',
            'startpoint.*.required'    => 'Please Enter Start Point',
            'endpoint.*.required'      => 'Please Enter End Point',
            'road_length.*.required'   => 'Please Enter Road Length',
            'defect_factor.*.required' => 'Please Select Defect Liability Factor',

            'start_date.required' => 'Please Select Start Date',
            'end_date.required'   => 'Please Select End Date',
        ];
    }
}
