<?php

namespace App\Http\Requests\PwdElectrical\CompletitionCertificate;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use App\Models\PwdElectrical\CompletionCertificateDevelopment;


class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    // public function rules(): array
    // {

    //     return [
    //         'applicant_name'=>'required',
    //         'applicant_address'=>'required',
    //         'mobile_no'=>'required',
    //         'email_id'=>'nullable',
    //         'company_name'=>'required',
    //         'work_name'=>'required',
    //         'work_order_no'=>'nullable',
    //         // 'work_comp_certi'=>'required',0
    //         'work_order_do'=>'nullable',
    //         'work_completition_certificate'=>'nullable'
    //     ];
    // }

      public function rules(): array
    {
       $completion_id = $this->route('completition_certificate');
       $completionworkquantity = CompletionCertificateDevelopment::find($completion_id);
        if (Auth::user()->hasRole('Clerk') || Auth::user()->hasRole('JuniorEngineer')) {
            $wardChanged =  $completionworkquantity && $this->ward_area !=  $completionworkquantity->ward_area;

            return [
                'ward_area' => 'required',
                'upload_photos' => ($wardChanged || ($completionworkquantity && $completionworkquantity->upload_photo))
                    ? 'nullable|file|mimes:pdf,jpg,jpeg,png'
                    : 'required|file|mimes:pdf,jpg,jpeg,png',
                'upload_reports' => ($wardChanged || ($completionworkquantity && $completionworkquantity->upload_report))
                    ? 'nullable|file|mimes:pdf,jpg,jpeg,png'
                    : 'required|file|mimes:pdf,jpg,jpeg,png',
                    ];
        }  else {
                    return [
                    'applicant_name'=>'required',
                    'applicant_address'=>'required',
                    'mobile_no'=>'required',
                    'email_id'=>'nullable',
                    'company_name'=>'required',
                    'work_name'=>'required',
                    'work_order_no'=>'nullable',
                    // 'work_comp_certi'=>'required',0
                    'work_order_do'=>'nullable',
                    'work_completition_certificate'=>'nullable'
                ];
        }
    }
}
