<?php

namespace App\Http\Requests\PwdElectrical\DevelopmentWorkQuantity;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'applicant_name'=>'required',
            'applicant_address'=>'required',
            'mobile_no' => ['required', 'regex:/^[0-9]{10}$/'],
            'email_id' => 'required|email',
            'company_name'=>'required',
            'work_name'=>'required',
            'work_order_no'=>'nullable',
            'work_completition_date'=>'nullable',
            'work_order_docs'=>'required',
            'work_completition_docs'=>'required',
            'ward_area' => 'required'
        ];
    }
}
