<?php

namespace App\Http\Requests\PwdElectrical\DevelopmentWorkQuantity;

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;
use App\Models\PwdElectrical\DevelopmentWorksQuantity;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $developmentworkquantity_id = $this->route('development_work_quantity');
        $developmentworkquantity = DevelopmentWorksQuantity::find($developmentworkquantity_id);

        if (Auth::user()->hasRole('Clerk') || Auth::user()->hasRole('JuniorEngineer')) {
            // check if ward area changed
            $wardChanged = $developmentworkquantity && $this->ward_area != $developmentworkquantity->ward_area;

            return [
                'ward_area' => 'required',

                'upload_photos' => ($wardChanged || ($developmentworkquantity && $developmentworkquantity->upload_photo))
                    ? 'nullable|file|mimes:pdf,jpg,jpeg,png'
                    : 'required|file|mimes:pdf,jpg,jpeg,png',

                'upload_reports' => ($wardChanged || ($developmentworkquantity && $developmentworkquantity->upload_report))
                    ? 'nullable|file|mimes:pdf,jpg,jpeg,png'
                    : 'required|file|mimes:pdf,jpg,jpeg,png',
            ];
        } else {
            return [
                'applicant_name' => 'required',
                'applicant_address' => 'required',
                'mobile_no' => ['required', 'regex:/^[0-9]{10}$/'],
                'email_id' => 'required|email',
                'company_name' => 'required',
                'work_name' => 'required',
                'work_order_no' => 'nullable',
                'work_completition_date' => 'nullable',
                'work_order_doc' => 'nullable',
                'work_completition_do' => 'nullable'
            ];
        }
    }
}
