<?php

namespace App\Http\Requests\PwdElectrical\WindBlow;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'applicant_name' => 'required|string|max:255',
            'applicant_address' => 'required|string|max:255',
            'mobile_no' => 'required|digits:10',
            'email_id' => 'required|email|max:255',

            'owner_name' => 'required|string|max:255',
            'owner_address' => 'required|string|max:255',
            'prabhag_samiti' => 'required|string|max:255',

            'cc_oc_certificate' => 'required|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'fire_noc' => 'required|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'solid_waste_noc' => 'required|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'structural_stability_certificate' => 'required|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'electrical_safety_certificate' => 'required|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'water_supply_sewage_noc' => 'required|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'prabhag_office_noc' => 'required|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'school_gps_photo' => 'required|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'upload_prescribed_format'=>'required|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'is_correct_info' => 'accepted',
        ];
    }
}
