<?php

namespace App\Http\Requests\PwdElectrical\WindBlow;

use Illuminate\Foundation\Http\FormRequest;

class updateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'applicant_name' => 'sometimes|required|string|max:255',
            'applicant_address' => 'sometimes|required|string|max:255',
            'mobile_no' => 'sometimes|required|digits:10',
            'email_id' => 'sometimes|required|email|max:255',

            'owner_name' => 'sometimes|required|string|max:255',
            'owner_address' => 'sometimes|required|string|max:255',
            'prabhag_samiti' => 'sometimes|required|string|max:255',

            'cc_oc_certificate' => 'sometimes|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'fire_noc' => 'sometimes|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'solid_waste_noc' => 'sometimes|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'structural_stability_certificate' => 'sometimes|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'electrical_safety_certificate' => 'sometimes|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'water_supply_sewage_noc' => 'sometimes|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'prabhag_office_noc' => 'sometimes|file|mimes:pdf,jpg,jpeg,png|max:10240',
            'school_gps_photo' => 'sometimes|file|mimes:pdf,jpg,jpeg,png|max:10240',

            // 'is_correct_info' => 'sometimes|accepted',
        ];
    }
}
