<?php

namespace App\Http\Requests\Trade\NocForMandap;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            //'applicant_name' => 'required',
            // 'applicant_name' => ['required', 'regex:/^[a-zA-Z\s]+$/'],
            'applicant_name' => ['required', 'regex:/^[A-Za-z\x{0900}-\x{097F}\s]+$/u'],
            //'applicant_mobile' => 'required',
            'applicant_mobile' => ['required', 'digits:10'],
            // 'applicant_email' => 'required',
            'applicant_email' => 'required|email',
            'applicant_address' => 'required',
            'ward_area' => 'required',
            'stage_address' => 'required',
            'stage_permission_date' => 'required',
            'stage_permission_end_date' => 'required',
            'registration_date' => 'required',
            'last_year_permission' => 'required',
            'stage_height' => 'required',
            'ganesh_murti_type' => 'required',
            'concerned_traffic_police_station' => 'required',
            'commissioner_name' => 'required',
            'registration_no' => 'required',
            'location_map_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'board_registration_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'traffic_last_year_noObjection_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'fire_last_year_noObjection_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            //'mandap_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'mandap_documents' => 'required_if:last_year_permission,yes|file|mimes:pdf,png,jpg,jpeg,PDF,PNG,JPG,JPEG|max:2048',
            'local_polic_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            // registration_date
            //last_year_permission
            //ganesh_murti_type
            //murti_height
            //mandap_documents
            //local_polic_documents

            //'event_name' => 'required',


            // 'registration_year' => 'required',
            // 'name_of_chairman' => 'required',
            // 'president_mobile_no' => 'required|min:10|max:10',
            // 'ownership_of_place' => 'required',

            //'no_of_days' => 'required',

            // 'zone' => 'nullable',

            // 'plot_no' => 'required',

            // 'stage_length' => 'required',
            // 'stage_Width' => 'required',
            //'stage_area' => 'required',
            // 'no_of_volunteer_workers' => 'required',
            //'stage_contractor_address' => 'required',
            // 'contractor_contact_no' => 'required',
            //'decorator_or_electrical_contractor_name' => 'required',
            //'decorator_or_contractor_address' => 'required',
            // 'decorator_or_electrical_contractor_contact_no' => 'required|min:10|max:10',
            // 'sound_or_speaker_contractor_name' => 'required',
            //'sound_or_speaker_address' => 'required',
            // 'sound_or_speaker_contractor_contact_no' => 'required|min:10|max:10',
            // 'sound_or_speaker_type' => 'required',
            //'concerned_police_station' => 'required',

            // 'nearest_fire_station' => 'required',

            // 'no_objection_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',


            //'annexures' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'is_correct_info' => 'required',
            'prescribed_docs' => 'required'
        ];
    }

    public function messages()
    {
        return [
            'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
