<?php

namespace App\Http\Requests\WaterDepartment\ChangeConnectionSize;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'new_owner_name' => 'nullable',
            'aadhar_no' => 'required|min:12|max:12',
            'mobile_no' => 'required|min:10|max:10',
           // 'email_id' => 'required',
            'zone' => 'nullable',
            'ward_area' => 'nullable',
            'plot_no' => 'nullable',
            'house_no' => 'nullable',
            'landmark' => 'nullable',
            'address' => 'required',
            'current_connection_is_authorized' => 'nullable',
            'applicant_or_tenant' => 'nullable',
            'no_of_user' => 'nullable',
            'criminal_judicial_issue' => 'nullable',
            'existing_connection_detail' => 'required',
            'old_tap_size' => 'required',
            'new_tap_size' => 'required',
            'new_tap_connection' => 'nullable',
            'place_belongs_to_municipal' => 'nullable',
            'comment' => 'nullable',
            'application_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'nodues_documents' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'is_correct_info' => 'required',

            'applicant_name' => 'required',
            'connection_no' => 'required',
            'property_tax' => 'nullable',
            'sub_usage' => 'nullable',
            'requirement_water_connection' => 'nullable',

        ];
    }

    public function messages()
    {
        return [
            'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
