<?php

namespace App\Http\Requests\WaterDepartment\ChangeInUse;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            // 'property_owner_name' => 'required',
            'aadhar_no' => 'required|min:12|max:12',
            'mobile_no' => 'required|min:10|max:10',
           // 'email_id' => 'required',
            'zone' => 'nullable',
            'ward_area' => 'nullable',
            'plot_no' => 'nullable',
            'house_no' => 'required',
            'landmark' => 'required',
            'address' => 'required',
            'property_type' => 'nullable',
           // 'water_connection_no' => 'required',
            'applicant_is_on_rent' => 'nullable',
            'water_connection_size' => 'nullable',
            'water_usage' => 'required',
            'new_water_con_usage' => 'required',
            'usage_residence_type' => 'nullable',
           // 'current_connection_is_illegal' => 'required',
            'no_of_user' => 'nullable',
            'place_belongs_to_municipal' => 'nullable',
            'any_police_complaint' => 'nullable',
            'application_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'nodues_documents' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'is_correct_info' => 'required',
            'total_connection' => 'nullable',
            'sub_usage' => 'nullable',
            'new_sub_usage' => 'nullable',
            'no_of_existing_con' => 'nullable',

            'Connection_Type' => 'required',
            'Water_Connection_Number' => 'required',
            'connection_no' => 'required',
            // 'House_Number' => 'required',  // Not there in form and get data is null for id D022023MBMC
            'House_Number' => 'nullable',
            'property_owner_name' => 'required',
            'Full_Address_Of_The_Property' => 'required',
            'Water_Connection_Size' => 'required',
            'Water_Connection_Usage' => 'required',
            // 'zone' => 'required',
            // 'Ward' => 'required',
            'OutstandingAmt' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
