<?php

namespace App\Http\Requests\WaterDepartment\ChangeOwnership;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'new_owner_name' => 'nullable',
            'aadhar_no' => 'required|min:12|max:12',
            'mobile_no' => 'required|min:10|max:10',
            'address' => 'nullable',
            //'email_id' => 'required',
            'property_no' => 'required',
            'zone' => 'nullable',
            'ward_area' => 'nullable',
            // 'new_tap_connection' => 'required',
            'house_no' => 'nullable',
            'landmark' => 'nullable',
           // 'existing_water_bill' => 'required',
           'existing_water_bill' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'tax_bill_or_transfer_order' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'stamp_paper_or_noobjection_cert' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'aadhar_doc' => 'nullable',
            'electricity_bill_or_pan_card' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            // 'current_connection_is_authorized' => 'required',
            // 'no_of_user' => 'required',
            // 'applicant_or_tenant' => 'required',
            // 'criminal_judicial_issue' => 'required',
            // 'old_owner_name' => 'required',
            // 'tap_size' => 'required',
            // 'existing_connection_detail' => 'required',
            // 'place_belongs_to_municipal' => 'required',
            'comment' => 'nullable',
            // 'application_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            // 'ownership_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'nodues_documents' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'is_correct_info' => 'required',
            'total_connection'=>'required',
            'connection_no'=>'required',
            'owner_name'=>'nullable',
            'owner_add'=>'nullable',
            'ward_area'=>'nullable',
            'zone'=>'required',
            'sub_usage' => 'nullable',
        ];
    }

    public function messages()
    {
        return [
            'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
