<?php

namespace App\Http\Requests\WaterDepartment\ChangeOwnership;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'new_owner_name' => 'required',
            'aadhar_no' => 'required|min:12|max:12',
            'mobile_no' => 'required|min:10|max:10',
            'address' => 'required',
            //'email_id' => 'required',
            'property_no' => 'required',
            'zone' => 'nullable',
            'ward_area' => 'nullable',
            // 'new_tap_connection' => 'required',
            'house_no' => 'required',
            'landmark' => 'required',
            // 'current_connection_is_authorized' => 'required',
            // 'no_of_user' => 'required',
            // 'applicant_or_tenant' => 'required',
            // 'criminal_judicial_issue' => 'required',
            // 'old_owner_name' => 'required',
            // 'tap_size' => 'required',
            // 'existing_connection_detail' => 'required',
            // 'place_belongs_to_municipal' => 'required',
            // 'application_documents' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            // 'application_documents' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'nodues_documents' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'comment' => 'nullable',
            // 'is_correct_info' => 'required',
            'total_connection'=>'required',
            'connection_no'=>'required',
            'owner_name'=>'required',
            'owner_add'=>'required',
            'ward_area'=>'required',
            'zone'=>'required'
        ];
    }

    public function messages()
    {
        return [
            // 'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
