<?php

namespace App\Http\Requests\WaterDepartment\DisconnectSupply;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'new_owner_name' => 'nullable',
            'aadhar_no' => 'required|min:12|max:12',
            'mobile_no' => 'required|min:10|max:10',
           // 'email_id' => 'required',
            'zone' => 'nullable',
            'ward_area' => 'nullable',
            'plot_no' => 'nullable',
            'house_no' => 'nullable',
            'landmark' => 'nullable',
            'address' => 'required',
            'current_connection_is_authorized' => 'nullable',
            'applicant_or_tenant' => 'nullable',
           // 'criminal_judicial_issue' => 'required',
            'tap_size' => 'nullable',
            'existing_connection_detail' => 'nullable',
            'place_belongs_to_municipal' => 'nullable',
            'comment' => 'nullable',
            'application_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'nodues_documents' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'is_correct_info' => 'required',
            'applicant_name' => 'required',
            'connection_no' => 'required',
            'disconnection_type' => 'required',
            'sub_usage' => 'nullable',
            'no_of_existing_con' => 'nullable',

            'Connection_Type' => 'required',
            // 'House_Number' => 'required',  // Not there in form and get data is null for id D022023MBMC
            'House_Number' => 'nullable',
            'Property_Owner_Name' => 'required',
            'Full_Address_Of_The_Property' => 'required',
            'Water_Connection_Size' => 'required',
            'Water_Connection_Usage' => 'required',
            'zone' => 'required',
            'Ward' => 'required',
            'OutstandingAmt' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
