<?php

namespace App\Http\Requests\WaterDepartment\NewWaterConnection;

use Illuminate\Foundation\Http\FormRequest;

class CreateNewConnectionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'applicant_full_name' => 'required',
            'aadhar_no' => 'required|min:12|max:12',
            'mobile_no' => 'required|min:10|max:10',
            'email_id' => 'nullable',
            'zone' => 'nullable',
            'prabhag' => 'nullable',
            'ward' => 'nullable',
            'ward_area' => 'nullable',
            'city_servey_no' => 'nullable',
            'address' => 'required',
            'landmark' => 'nullable',
            'no_of_flats_shops' => 'required',
            'property_no' => 'required',
            'total_person' => 'nullable',
            'distance' => 'nullable',
            'water_connection_use' => 'required',
            'pipe_size' => 'required',
            'no_of_tap' => 'required',
            'current_no_of_tap' => 'required',
            'total_tenants' => 'nullable',
           //'written_application_document' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'written_application_document' => 'required|file|mimes:pdf,png,jpg,jpeg|max:10240',
            'address_proof' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'ownership_document' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'no_dues_document' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'jote_doc' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'stamp_karnama' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'oc_and_cc' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'structure_photo' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'is_correct_info' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
