<?php

namespace App\Http\Requests\WaterDepartment\PlumberLicense;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'applicant_name' => 'required',
            'address' => 'required',
            'aadhar_no' => 'required|min:12|max:12',
            'mobile_no' => 'required|min:10|max:10',
            //'email_id' => 'required',
            'zone' => 'nullable',
            'ward_area' => 'nullable',
            'education_institutation' => 'nullable',
            'education_qualification' => 'nullable',
            'training_institute_name' => 'required',
            'year_of_passing' => 'required',
            'have_experience' => 'required',
            'application_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'nodues_documents' => 'required|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            'is_correct_info' => 'required',
           // 'house_no'=>'required',
            'land_mark'=>'required',
            'CreateRequest'=>'nullable',

            'Connection_Type' => 'nullable',
            // 'House_Number' => 'required',  // Not there in form and get data is null for id D022023MBMC
            'House_Number' => 'nullable',
            'Property_Owner_Name' => 'nullable',
            'Full_Address_Of_The_Property' => 'nullable',
            'Water_Connection_Size' => 'nullable',
            'Water_Connection_Usage' => 'nullable',
            'zone' => 'nullable',
            'Ward' => 'nullable',
            'OutstandingAmt' => 'nullable',
        ];
    }

    public function messages()
    {
        return [
            'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
