<?php

namespace App\Http\Requests\WaterDepartment\Reconnection;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'new_owner_name' => 'required',
            'aadhar_no' => 'required|min:12|max:12',
            'mobile_no' => 'required|min:10|max:10',
            //'email_id' => 'required',
            'zone' => 'nullable',
            'ward_area' => 'nullable',
            'plot_no' => 'required',
            'house_no' => 'required',
            //'landmark' => 'required',
            'address' => 'required',
            // 'new_tap_connection' => 'required',
            // 'current_connection_is_authorized' => 'required',
            // 'applicant_or_tenant' => 'required',
            // 'no_of_user' => 'required',
            // 'criminal_judicial_issue' => 'required',
            // 'tap_size' => 'required',
            // 'existing_connection_detail' => 'required',
            // 'place_belongs_to_municipal' => 'required',
            'comment' => 'nullable',
            'application_documents' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:2048',
            'nodues_documents' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:5048',
            // 'is_correct_info' => 'required',
             'connection_no'=>'required',
            'owner_name'=>'required',
            'owner_full_add'=>'required',
            'connection_size'=>'required',
            'prev_water_bill'=>'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:5048',

            //'criminal'=>'required'
        ];
    }

    public function messages()
    {
        return [
            // 'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
