<?php

namespace App\Http\Requests\WaterDepartment\TaxBill;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'property_owner_name' => 'required',
            'aadhar_no' => 'required|min:12|max:12',
            'mobile_no' => 'required|min:10|max:10',
            //'email_id' => 'required',
            'applicant_name' => 'required',
            'zone' => 'nullable',
            'ward_area' => 'nullable',
            'no_of_existing_con' => 'nullable',
            'plot_no' => 'required',
            'house_no' => 'required',
            'landmark' => 'required',
            'address' => 'required',
            'connection_no' => 'required',
            'property_no' => 'nullable',
            'city_serve_no' => 'nullable',
            'new_water_con' => 'required',
            'current_connection_is_illegal' => 'required',
            'applicant_or_tenant' => 'required',
            'criminal_judicial_issue' => 'required',
            'place_belongs_to_municipal' => 'required',
            'comment' => 'nullable',
            'application_documents' => 'nullable|file|mimes:pdf,PDF,png,PNG,jpg,JPG,jpeg,JPEG|max:10240',
            // 'is_correct_info' => 'required',
            'owner_full_add'=>'nullable',
            'water_connection'=>'nullable',
            'water_sub_usage'=>'required',
            'connection_size'=>'nullable',
            'billing_cycle'=>'required'
        ];
    }

    public function messages()
    {
        return [
            // 'is_correct_info.required' => 'Please Accept Declaration'
        ];
    }
}
