<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApprovalHierarchies extends Model
{
    use SoftDeletes, HasFactory;

    protected $table = "approval_hierarchies";

    protected $fillable = [
        'service_id',
        'status_id',
        'table_id',
        'user_id',
        'approver_user_id',
        'status',
        'remark',
        'next_approval_flag',
        'is_reverted',
    ];


    public function approver()
    {
        return $this->belongsTo(User::class, 'approver_user_id');
    }

    public function status()
    {
        return $this->belongsTo(Status::class, 'status_id');
    }

    public function citizen()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id');
    }

    public function serviceName()
    {
        return $this->belongsTo(ServiceName::class, 'service_id', 'service_id');
    }


}
