<?php

namespace App\Models;

use App\Models\Department;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Role;

class ApprovalRequestHierarchy extends Model
{
    use SoftDeletes, HasFactory;

    protected $table = "approval_request_hierarchies";

    protected $fillable = [
        'requester_department_id',
        'first_approver_designation_id',
        'second_approver_designation_id',
        'third_approver_designation_id',
        'fourth_approver_designation_id',
        'first_department_id',
        'second_department_id',
        'third_department_id',
        'fourth_department_id',
        'five_department_id',
        'six_department_id',
        'seven_department_id',
        'eight_department_id',
        'five_approver_designation_id',
        'six_approver_designation_id',
        'seven_approver_designation_id',
        'eight_approver_designation_id',
        'service_id'
    ];

    public function firstApproverDesignations()
    {
        return $this->hasOne(Role::class, 'id', 'first_approver_designation_id');
    }


    public function secondApproverDesignations()
    {
        return $this->hasOne(Role::class, 'id', 'second_approver_designation_id');
    }


    public function thirdApproverDesignations()
    {
        return $this->hasOne(Role::class, 'id', 'third_approver_designation_id');
    }


    public function fourthApproverDesignations()
    {
        return $this->hasOne(Role::class, 'id', 'fourth_approver_designation_id');
    }

    public function fiveApproverDesignations()
    {
        return $this->hasOne(Role::class, 'id', 'five_approver_designation_id');
    }

     public function sixApproverDesignations()
    {
        return $this->hasOne(Role::class, 'id', 'six_approver_designation_id');
    }

     public function sevenApproverDesignations()
    {
        return $this->hasOne(Role::class, 'id', 'seven_approver_designation_id');
    }

    public function eightApproverDesignations(){
        return $this->hasone(Role::class, 'id' , 'eight_approver_designation_id');
    }

    public function requesterDepartment()
    {
        return $this->belongsTo(Department::class, 'requester_department_id');
    }

    public function requestserviceName()
    {
        return $this->belongsTo(ServiceName::class, 'service_id', 'service_id');
    }

    public function firstApproverDepartment()
    {
        return $this->belongsTo(Department::class, 'first_department_id');
    }

     public function secondApproverDepartment()
    {
        return $this->belongsTo(Department::class, 'second_department_id');
    }

     public function thirdApproverDepartment()
    {
        return $this->belongsTo(Department::class, 'third_department_id');
    }

     public function fourthApproverDepartment()
    {
        return $this->belongsTo(Department::class, 'fourth_department_id');
    }

     public function fiveApproverDepartment()
    {
        return $this->belongsTo(Department::class, 'five_department_id');
    }

      public function sixApproverDepartment()
    {
        return $this->belongsTo(Department::class, 'six_department_id');
    }

      public function sevenApproverDepartment()
    {
        return $this->belongsTo(Department::class, 'seven_department_id');
    }

      public function eightApproverDepartment()
    {
        return $this->belongsTo(Department::class, 'eight_department_id');
    }
}
