<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;

class CityClean extends Model
{
    use HasFactory;
    protected $table = 'city_clean';

    protected $fillable = [
        'application_no',
        'service_id',
        'user_id',
        'ip',
        'applicant_name',
        'applicant_address',
        'mobile_no',
        'email',
        'aadhar_num',
        'address',
        'geo_photos',
        'upload_prescribed_docs',
        'status'
    ];

     public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }


    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
