<?php

namespace App\Models\ConstructionDepartment;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;


class ConstructionDrainageConnection extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'service_id',
        'status',
        'status_remark',
        'ward_area',
        'payment_date',
        'is_payment_paid',
        'upic_id',
        'application_no',
        'is_aapale_sarkar_payment_paid',
        'aapale_sarkar_payment_date',
        'applicant_name',
        'applicant_area_details',
        'applicant_full_address',
        'zone',
        'ward',
        'mobile_no',
        'aadhar_no',
        'address',
        'email_id',
        'property_number',
        'property_usage',
        'connection_size_inches',
        'construction_date',
        'flat_assesment_date',
        'flat_map_date',
        'current_water_tax_amount',
        'current_tax_paid_date',
        'lichpit_count',
        'is_toilet_available',
        'total_residencial_people_count',
        'total_renter_count',
        'connection_size_feet',
        'upload_prescribed_format',
        'upload_no_dues_certificate',
        'upload_property_ownership',
        'ip',
        'connection_count',
        'oc_cc_doc',

        'Connection_Type',
        'House_Number',
        'Property_Owner_Name',
        'Full_Address_Of_The_Property',
        'Water_Connection_Size',
        'Water_Connection_Usage',
        'OutstandingAmt',
    ];

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

     public function user()
    {
        return $this->belongsTo(User::class);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
