<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DepartmentUser extends Model
{
    use HasFactory;

    protected $table = 'department_user';

    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $fillable = [
        'department_id',
        'user_id',
        'created_at',
        'updated_at',
        'ward_name',
        'prabhag'
    ];

    public $timestamps = true;

    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }

    public function ward()
    {
        return $this->belongsTo(Ward::class, 'ward_name', 'id');
    }

    public function prabhags()
    {
        return $this->belongsTo(Prabhag::class, 'prabhag', 'id');
    }


    public function prabhagWard()
    {
        return $this->belongsTo(PrabhagWard::class, 'ward_name', 'id');
    }

    public function waterPrabhag()
    {
        return $this->belongsTo(WaterPrabhag::class, 'prabhag', 'id');
    }

    public function waterPrabhagWard()
    {
        return $this->belongsTo(WaterPrabhagWards::class, 'ward_name', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }



}
