<?php

namespace App\Models\DrinageWater;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;


class FailureWater extends Model
{
    use HasFactory;

    protected $table = "failure_water_supply";

    protected $fillable = [
        'user_id',
        'ip',
        'applicantname',
        'application_no',
        'service_id',
        //'email',
        'mobileno',
        'applicantaddress',
        'survey_no',
        'zone',
        'waterconnectionno',
        'propertyno',
       // 'adhaarno',
        'application_doc',
        'site_photo',
        'cc_oc',
        'blue_print',
        'other_doc',
        'status',
        'ward_area',
        'is_payment_paid',
        'upload_photo',
        'aapale_sarkar_payment_date',
        'is_payment_paid_aapale_sarkar'
    ];

       public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
