<?php

namespace App\Models\DrinageWater;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;


class SewerageProperty extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'ip',
        'applicant_name',
        'applicant_address',
        'application_no',
        'service_id',
        'mobile_no',
        'zone',
        'property_no',
        'application_doc',
        'bill_doc',
        'site_photo',
        'blue_print',
        'other_doc',
        'status',
        //'tax_no',
        'upload_site_photo',
        'ward_area',
        'is_payment_paid',
        'aapale_sarkar_payment_date',
        'is_payment_paid_aapale_sarkar'
    ];

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function status(){
        return $this->hasOne(Status::class,'table_id','id');
    }

     public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

     protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
