<?php

namespace App\Models\DrinageWater;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\User;
use App\Models\Status;

class WaterDues extends Model
{
    use HasFactory;

    protected $fillable=[
       'user_id',
       'ip',
       'applicant_full_name',
       'application_no',
       'applicant_full_address',
       'mobile_no',
       'email_id',
       'adhar_no',
       'total_connection',
       'connection_no',
       'owner_name',
       'owner_full_add',
       'landmark',
       'ward_area',
       'zone',
       'connection_size',
       'upload_water_bill',
       'service_id',
       'payment_date',
       'is_payment_paid',
       'is_payment_paid_appale_sarkar',
       'appale_sarkar_payment_date',
       'status',
       'application_documents'
    ];

    public function user(){
        return $this->belongsTo(User::class);
    }
    public function status(){
        return $this->hasOne(Status::class,'table_id','id');
    }

     public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
