<?php

namespace App\Models\EstateVibhag;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;

class SolarPower extends Model
{
    use HasFactory;

    protected $table = "solarpower";

    protected $fillable = [
        'user_id',
        'ip',
        'applicant_name',
        'applicant_address',
        'mobile_no',
        'stall_place',
        'stall_type',
        'authorization',
        'mul_parnaga_pic',
        'adhar_card_pic',
        'pic',
        'handicap_pic',
        'caste_pic',
        'milk_center_pic',
        'gumasta_license_pic',
        'application_no',
        'service_id',
        'payment_date',
        'is_payment_paid',
        'is_payment_paid_aapale_sarkar',
        'aapale_sarkar_payment_date',
        'status',
        'ward_area',
        'prescribed_doc'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
