<?php

namespace App\Models\InsuranceOfBirthCertificate;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;

class InsuranceBirth extends Model
{
    use HasFactory;

    protected $fillable=[
        'user_id',
        'ip',
        'surname',
        'name',
        'father_name',
        'address',
        'room_name',
        'block_no',
        'road_name',
        'ward',
        'pincode_no',
        'ward_no',
        'mbmc_elec_ward_no',
        'contact_no',
        'mother_full_name',
        'father_full_name',
        'mother_father_address',
        'birth_place',
        'birth_date',
        'gender',
        'child_name',
        'no_of_certificate',
        'application_no',
        'service_id',
        'payment_date',
        'is_payment_paid',
        'is_payment_paid_aapale_sarkar',
        'aapale_sarkar_payment_date',
        'status',
        'uploaded_application',
    ];

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function status(){
        return $this->hasOne(Status::class,'table_id','id');
    }

     public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot(){
        parent::boot();

        static::creating(function($model){
            $model->ip = Request::ip();
        });
    }

}
